/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.junit.jupiter.api.Test;

public class OnCompletionContainsTest
extends ContextTestSupport {
    @Test
    public void testOnCompletionContainsTest() throws Exception {
        this.getMockEndpoint("mock:sync").expectedBodiesReceived(new Object[]{"C", "B", "B", "A", "Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onCompletion().to("mock:sync");
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        SimpleSynchronizationAdapter adapter = new SimpleSynchronizationAdapter("mock:sync", "A");
                        exchange.getExchangeExtension().addOnCompletion((Synchronization)adapter);
                        if (!exchange.getExchangeExtension().containsOnCompletion((Synchronization)adapter)) {
                            exchange.getExchangeExtension().addOnCompletion((Synchronization)adapter);
                        }
                        adapter = new SimpleSynchronizationAdapter("mock:sync", "B");
                        exchange.getExchangeExtension().addOnCompletion((Synchronization)adapter);
                        if (exchange.getExchangeExtension().containsOnCompletion((Synchronization)adapter)) {
                            exchange.getExchangeExtension().addOnCompletion((Synchronization)adapter);
                        }
                        exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                OnCompletionContainsTest.this.template.sendBody("mock:sync", (Object)"C");
                            }

                            public String toString() {
                                return "C";
                            }
                        });
                    }
                })).to("mock:result");
            }
        };
    }

    class SimpleSynchronizationAdapter
    extends SynchronizationAdapter {
        private final String endPoint;
        private final String body;

        SimpleSynchronizationAdapter(String endPoint, String body) {
            this.endPoint = endPoint;
            this.body = body;
        }

        public void onDone(Exchange exchange) {
            OnCompletionContainsTest.this.template.sendBody(this.endPoint, (Object)this.body);
        }

        public String toString() {
            return this.body;
        }
    }
}

