/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnCompletionBridgeErrorHandlerTest
extends ContextTestSupport {
    protected final CountDownLatch latch = new CountDownLatch(1);

    @Test
    public void test() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.latch.countDown();
        this.assertMockEndpointsSatisfied();
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)cause);
        Assertions.assertEquals((Object)"Simulated", (Object)cause.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.getContext().addComponent("my", (Component)new MyComponent());
                this.errorHandler((ErrorHandlerFactory)this.noErrorHandler());
                ((OnCompletionDefinition)this.from("my:foo?bridgeErrorHandler=true").onCompletion().to("mock:dead")).end().to("mock:result");
            }
        };
    }

    public static class MyConsumer
    extends ScheduledPollConsumer {
        public MyConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        protected int poll() {
            throw new IllegalArgumentException("Simulated");
        }
    }

    public static class MyEndpoint
    extends DefaultEndpoint {
        public MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            MyConsumer answer = new MyConsumer((Endpoint)this, processor);
            this.configureConsumer((Consumer)answer);
            return answer;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    public static class MyComponent
    extends DefaultComponent {
        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyEndpoint(uri, (Component)this);
        }
    }
}

