/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnCompletionAsyncTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAsyncComplete() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((OnCompletionDefinition)this.onCompletion().parallelProcessing().to("mock:before")).delay(250L).setBody((Expression)this.simple("OnComplete:${body}"))).to("mock:after");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"OnComplete:Bye World"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAsyncFailure() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((OnCompletionDefinition)this.onCompletion().parallelProcessing().to("mock:before")).delay(250L).setBody((Expression)this.simple("OnComplete:${body}"))).to("mock:after");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"OnComplete:Kaboom"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Kaboom");
            Assertions.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Kaboom", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAsyncCompleteUseOriginalBody() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((OnCompletionDefinition)this.onCompletion().useOriginalBody().parallelProcessing().to("mock:before")).delay(250L).setBody((Expression)this.simple("OnComplete:${body}"))).to("mock:after");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"OnComplete:Hello World"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAsyncFailureUseOriginalBody() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((OnCompletionDefinition)this.onCompletion().useOriginalBody().parallelProcessing().to("mock:before")).delay(250L).setBody((Expression)this.simple("OnComplete:${body}"))).to("mock:after");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Before:${body}"))).process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"OnComplete:Kaboom"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Kaboom");
            Assertions.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Kaboom", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAsyncCompleteOnCompleteFail() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((OnCompletionDefinition)this.onCompletion().parallelProcessing().to("mock:before")).delay(250L).setBody((Expression)this.simple("OnComplete:${body}"))).throwException((Exception)new IllegalAccessException("From onComplete"))).to("mock:after");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            if (((String)exchange.getIn().getBody(String.class)).contains("Kaboom")) {
                throw new IllegalArgumentException("Kaboom");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

