/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnCompletionAndInterceptGlobalTest
extends ContextTestSupport {
    @Test
    public void testSynchronizeComplete() throws Exception {
        this.getMockEndpoint("mock:intercept").expectedMinimumMessageCount(4);
        this.getMockEndpoint("mock:sync").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:sync").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSynchronizeFailure() throws Exception {
        this.getMockEndpoint("mock:intercept").expectedMinimumMessageCount(4);
        this.getMockEndpoint("mock:sync").expectedMessageCount(1);
        this.getMockEndpoint("mock:sync").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            Assertions.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Kaboom", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.intercept().to("mock:intercept");
                ((OnCompletionDefinition)this.onCompletion().to("log:global")).to("mock:sync");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            if ("Kaboom".equals(exchange.getIn().getBody())) {
                throw new IllegalArgumentException("Kaboom");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

