/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;
import org.junit.jupiter.api.Test;

public class OnCompletionAfterChainedSedaRoutesTest
extends ContextTestSupport {
    @Test
    public void testOnCompletionChained() throws Exception {
        String body = "<body>";
        MockEndpoint completionMockEndpoint = this.getMockEndpoint("mock:completion");
        completionMockEndpoint.expectedMessageCount(5);
        completionMockEndpoint.expectedBodiesReceived(new Object[]{"<body>", "completion:d", "completion:c", "completion:b", "completion:a"});
        this.template.sendBody("direct:a", (Object)"<body>");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)((OnCompletionDefinition)((OnCompletionDefinition)this.from("direct:a").onCompletion().log("a - done")).process(exchange -> exchange.getMessage().setBody((Object)"completion:a"))).to("mock:completion")).end().to("seda:b");
                ((OnCompletionDefinition)((OnCompletionDefinition)((OnCompletionDefinition)this.from("seda:b").onCompletion().log("b - done")).process(exchange -> exchange.getMessage().setBody((Object)"completion:b"))).to("mock:completion")).end().delay(100L).to("seda:c");
                ((OnCompletionDefinition)((OnCompletionDefinition)((OnCompletionDefinition)this.from("seda:c").onCompletion().log("c - done")).process(exchange -> exchange.getMessage().setBody((Object)"completion:c"))).to("mock:completion")).end().delay(100L).to("seda:d");
                ((OnCompletionDefinition)((OnCompletionDefinition)((OnCompletionDefinition)this.from("seda:d").onCompletion().log("d - done")).process(exchange -> exchange.getMessage().setBody((Object)"completion:d"))).to("mock:completion")).end().delay(100L).to("mock:completion");
            }
        };
    }
}

