/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NotAllowRedeliveryWhileStoppingTest
extends ContextTestSupport {
    @Test
    public void testRedelivery() throws Exception {
        StopWatch watch = new StopWatch();
        MockEndpoint before = this.getMockEndpoint("mock:foo");
        before.expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(500L);
        this.context.stop();
        Assertions.assertTrue((watch.taken() < 5000L ? 1 : 0) != 0, (String)("Should stop quickly: " + watch.taken()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(5).redeliveryDelay(5000L).allowRedeliveryWhileStopping(false));
                ((RouteDefinition)this.from("seda:start").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

