/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NotAllowRedeliveryWhileStoppingDeadLetterChannelTest
extends ContextTestSupport {
    @Test
    public void testRedelivery() throws Exception {
        StopWatch watch = new StopWatch();
        MockEndpoint before = this.getMockEndpoint("mock:foo");
        before.expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(500L);
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertTrue((watch.taken() < 5000L ? 1 : 0) != 0, (String)("Should stop quickly: " + watch.taken()));
        Exchange dead = (Exchange)this.getMockEndpoint("mock:dead").getExchanges().get(0);
        Assertions.assertNotNull((Object)dead);
        Throwable cause = (Throwable)dead.getProperty("CamelExceptionCaught", Throwable.class);
        Assertions.assertNotNull((Object)cause);
        NotAllowRedeliveryWhileStoppingDeadLetterChannelTest.assertIsInstanceOf(RejectedExecutionException.class, cause);
        Assertions.assertEquals((Object)"Redelivery not allowed while stopping", (Object)cause.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").maximumRedeliveries(5).redeliveryDelay(5000L).allowRedeliveryWhileStopping(false));
                ((RouteDefinition)this.from("seda:start").routeId("foo").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

