/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.processor.MyNormalizer;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class NormalizerTest
extends ContextTestSupport {
    @Test
    public void testSendToFirstWhen() throws Exception {
        String employeeBody1 = "<employee><name>Jon</name></employee>";
        String employeeBody2 = "<employee><name>Hadrian</name></employee>";
        String employeeBody3 = "<employee><name>Claus</name></employee>";
        String customerBody = "<customer name=\"James\"/>";
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(4);
        result.expectedBodiesReceivedInAnyOrder(new Object[]{"<person name=\"Jon\"/>", "<person name=\"Hadrian\"/>", "<person name=\"Claus\"/>", "<person name=\"James\"/>"});
        this.template.sendBody("direct:start", (Object)employeeBody1);
        this.template.sendBody("direct:start", (Object)employeeBody2);
        this.template.sendBody("direct:start", (Object)employeeBody3);
        this.template.sendBody("direct:start", (Object)customerBody);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("normalizer", (Object)new MyNormalizer());
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().xpath("/employee")).to("bean:normalizer?method=employeeToPerson")).when().xpath("/customer")).to("bean:normalizer?method=customerToPerson")).end().to("mock:result");
            }
        };
    }
}

