/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NewProcessorAndServiceTest
extends ContextTestSupport {
    private MyProcessor myProcessor;

    @Test
    public void testNewProcessorAndService() {
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        Assertions.assertTrue((boolean)this.myProcessor.isStarted(), (String)"MyProcessor should be started");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                NewProcessorAndServiceTest.this.myProcessor = new MyProcessor();
                this.from("direct:start").process((Processor)NewProcessorAndServiceTest.this.myProcessor);
            }
        };
    }

    private static class MyProcessor
    implements Processor,
    Service {
        private boolean started;

        private MyProcessor() {
        }

        public void process(Exchange exchange) {
            exchange.getMessage().setBody((Object)"Bye World");
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.started = false;
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

