/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NestedChoiceWithEndChoiceIssueTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext ctx = super.createCamelContext();
        ctx.getCamelContextExtension().addContextPlugin(NodeIdFactory.class, (Object)NestedChoiceWithEndChoiceIssueTest.buildNodeIdFactory());
        return ctx;
    }

    private static NodeIdFactory buildNodeIdFactory() {
        return new NodeIdFactory(){

            public String createId(NamedNode definition) {
                return definition.getShortName();
            }
        };
    }

    @Test
    public void testNestedChoiceOtherwise() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        String expected = IOHelper.stripLineComments((Path)Paths.get("src/test/resources/org/apache/camel/processor/NestedChoiceWithEndChoiceIssueTest.xml", new String[0]), (String)"#", (boolean)true);
        expected = StringHelper.after((String)expected, (String)"-->");
        Assertions.assertEquals((Object)expected, (Object)("\n" + xml + "\n"));
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"2"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("count", (Object)"1000");
        this.template.sendBodyAndHeader("direct:start", (Object)1, "count", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:test").routeId("myRoute").choice().when((Predicate)this.simple("${header.count} < 1000 && ${body} == 0")).setHeader("count", (Expression)this.simple("${header.count}++"))).setBody((Expression)this.constant(1))).log("First when. Header is:${header.count} Body is:${body}")).to("direct:test")).when((Predicate)this.simple("${header.count} < 1000 && ${body} == 1")).setHeader("count", (Expression)this.simple("${header.count}++"))).setBody((Expression)this.constant(2))).log("Second when. Header is:${header.count} Body is:${body}")).to("direct:test")).when((Predicate)this.simple("${header.count} < 1000 && ${body} == 2")).setHeader("count", (Expression)this.simple("${header.count}++"))).setBody((Expression)this.constant(0))).choice().when((Predicate)this.simple("${header.count} < 500")).log("Third when and small header. Header is:${header.count} Body is:${body}")).when((Predicate)this.simple("${header.count} < 900")).log("Third when and big header. Header is:${header.count} Body is:${body}")).otherwise().log("Third when and header over 900. Header is:${header.count} Body is:${body}")).choice().when((Predicate)this.simple("${header.count} == 996")).log("Deep choice log. Header is:${header.count}")).setHeader("count", (Expression)this.constant(998))).end().endChoice().end().to("direct:test").endChoice().otherwise().log("Header is:${header.count}")).log("Final Body is:${body}")).end();
                ((RouteDefinition)this.from("direct:start").routeId("start").to("direct:test")).to("mock:result");
            }
        };
    }
}

