/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NestedChoiceOtherwiseIssueTest
extends ContextTestSupport {
    @Test
    public void testNestedChoiceOtherwise() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:other2").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)10);
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:other2").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "bar", (Object)11);
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:other2").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "cheese", (Object)12);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").routeId("myRoute").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).choice().when((Predicate)this.header("foo")).to("mock:foo")).otherwise().to("mock:other")).choice().when((Predicate)this.header("bar")).to("mock:bar")).endChoice().otherwise().to("mock:other2")).end().end();
            }
        };
    }
}

