/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.support.processor.ConvertBodyProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NavigateRouteTest
extends ContextTestSupport {
    private final List<Processor> processors = new ArrayList<Processor>();

    @Test
    public void testNavigateRoute() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Navigate nav = ((Route)this.context.getRoutes().get(0)).navigate();
        this.navigateRoute((Navigate<Processor>)nav);
        Assertions.assertEquals((int)6, (int)this.processors.size(), (String)"There should be 6 processors to navigate");
    }

    private void navigateRoute(Navigate<Processor> nav) {
        if (!nav.hasNext()) {
            return;
        }
        if (nav.getClass().getName().endsWith("ProcessorToReactiveProcessorBridge")) {
            nav = (Navigate)nav.next().get(0);
        }
        for (Processor child : nav.next()) {
            this.processors.add(child);
            if (child instanceof SendProcessor) {
                SendProcessor send = (SendProcessor)child;
                Assertions.assertEquals((Object)"mock://result", (Object)send.getDestination().getEndpointUri());
            }
            if (child instanceof ConvertBodyProcessor) {
                ConvertBodyProcessor convert = (ConvertBodyProcessor)child;
                Assertions.assertEquals(String.class, (Object)convert.getType());
            }
            if (!(child instanceof Navigate)) continue;
            this.navigateRoute((Navigate<Processor>)((Navigate)child));
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").convertBodyTo(String.class)).split((Expression)this.body().tokenize(" ")).to("mock:result");
            }
        };
    }
}

