/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.processor.MulticastParallelTest;
import org.apache.camel.spi.ThreadPoolProfile;

public class MulticastThreadPoolProfileTest
extends MulticastParallelTest {
    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ThreadPoolProfile profile = new ThreadPoolProfileBuilder("myProfile").poolSize(Integer.valueOf(5)).maxPoolSize(Integer.valueOf(10)).maxQueueSize(Integer.valueOf(20)).build();
                MulticastThreadPoolProfileTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(profile);
                ((MulticastDefinition)this.from("direct:start").multicast(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().executorService("myProfile").to(new String[]{"direct:a", "direct:b"})).end().to("mock:result");
                this.from("direct:a").delay(100L).setBody((Expression)this.constant("A"));
                this.from("direct:b").setBody((Expression)this.constant("B"));
            }
        };
    }
}

