/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.AppendingProcessor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MulticastTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Test
    public void testSendingAMessageUsingMulticastReceivesItsOwnExchange() throws Exception {
        this.x.expectedBodiesReceived(new Object[]{"input+output"});
        this.y.expectedBodiesReceived(new Object[]{"input+output"});
        this.z.expectedBodiesReceived(new Object[]{"input+output"});
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"input");
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        final AppendingProcessor processor = new AppendingProcessor();
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").multicast().to(new String[]{"direct:x", "direct:y", "direct:z"});
                ((RouteDefinition)this.from("direct:x").process(processor)).to("mock:x");
                ((RouteDefinition)this.from("direct:y").process(processor)).to("mock:y");
                ((RouteDefinition)this.from("direct:z").process(processor)).to("mock:z");
            }
        };
    }
}

