/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MulticastStreamCachingTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Test
    public void testSendingAMessageUsingMulticastConvertsToReReadable() throws Exception {
        this.x.expectedBodiesReceived(new Object[]{"<input/>+output"});
        this.y.expectedBodiesReceived(new Object[]{"<input/>+output"});
        this.z.expectedBodiesReceived(new Object[]{"<input/>+output"});
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)new StreamSource(new StringReader("<input/>")));
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                String body = (String)in.getBody(String.class);
                in.setBody((Object)(body + "+output"));
            }
        };
        return new RouteBuilder(){

            public void configure() {
                MulticastStreamCachingTest.this.context.setStreamCaching(Boolean.valueOf(true));
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                this.from("direct:a").multicast().to(new String[]{"direct:x", "direct:y", "direct:z"});
                ((RouteDefinition)this.from("direct:x").process(processor)).to("mock:x");
                ((RouteDefinition)this.from("direct:y").process(processor)).to("mock:y");
                ((RouteDefinition)this.from("direct:z").process(processor)).to("mock:z");
            }
        };
    }
}

