/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MulticastStopOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testMulticastStopOnExceptionOk() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello"});
        this.getMockEndpoint("mock:baz").expectedBodiesReceived(new Object[]{"Hello"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello"});
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMulticastStopOnExceptionStop() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            Assertions.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelExchangeException cause = MulticastStopOnExceptionTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            Assertions.assertTrue((boolean)cause.getMessage().startsWith("Multicast processing failed for number 1."));
            Assertions.assertEquals((Object)"Forced", (Object)cause.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from("direct:start").multicast().stopOnException().to(new String[]{"direct:foo", "direct:bar", "direct:baz"})).end().to("mock:result");
                this.from("direct:foo").to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").process((Processor)new MyProcessor())).to("mock:bar");
                this.from("direct:baz").to("mock:baz");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Kaboom".equals(body)) {
                throw new IllegalArgumentException("Forced");
            }
        }
    }
}

