/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MulticastRedeliverTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.template.sendBody("direct:test1", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testThrowExceptionAtA() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:test2", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)counter);
    }

    @Test
    public void testThrowExceptionAtB() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:test3", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)counter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(0L));
                ((MulticastDefinition)this.from("direct:test1").multicast().stopOnException().to("mock:a")).to("mock:b");
                ((MulticastDefinition)((MulticastDefinition)this.from("direct:test2").multicast().stopOnException().to("mock:a")).to("direct:a")).to("mock:b");
                ((MulticastDefinition)((MulticastDefinition)((MulticastDefinition)this.from("direct:test3").multicast().stopOnException().to("mock:a")).to("mock:b")).to("direct:b")).to("mock:c");
                this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        Assertions.assertFalse((boolean)exchange.hasOut(), (String)"Should not have OUT");
                        Assertions.assertNull((Object)exchange.getException());
                        ++counter;
                        throw new IllegalArgumentException("Forced");
                    }
                });
                this.from("direct:b").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        Assertions.assertFalse((boolean)exchange.hasOut(), (String)"Should not have OUT");
                        Assertions.assertNull((Object)exchange.getException());
                        exchange.getMessage().setBody((Object)"Bye World");
                        ++counter;
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }
}

