/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class MulticastPipelineTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testPlainPipeline() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").pipeline(new String[]{"direct:a", "direct:b"})).pipeline(new String[]{"direct:c", "direct:d"})).to("mock:result");
                ((RouteDefinition)this.from("direct:a").to("mock:a")).setBody().constant((Object)"A");
                ((RouteDefinition)this.from("direct:b").to("mock:b")).setBody().constant((Object)"B");
                ((RouteDefinition)this.from("direct:c").to("mock:c")).setBody().constant((Object)"C");
                ((RouteDefinition)this.from("direct:d").to("mock:d")).setBody().constant((Object)"D");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"A"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"B"});
        this.getMockEndpoint("mock:d").expectedBodiesReceived(new Object[]{"C"});
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPlainPipelineTo() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((PipelineDefinition)((PipelineDefinition)this.from("direct:start").pipeline().to(new String[]{"direct:a", "direct:b"})).end().pipeline().to(new String[]{"direct:c", "direct:d"})).end().to("mock:result");
                ((RouteDefinition)this.from("direct:a").to("mock:a")).setBody().constant((Object)"A");
                ((RouteDefinition)this.from("direct:b").to("mock:b")).setBody().constant((Object)"B");
                ((RouteDefinition)this.from("direct:c").to("mock:c")).setBody().constant((Object)"C");
                ((RouteDefinition)this.from("direct:d").to("mock:d")).setBody().constant((Object)"D");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"A"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"B"});
        this.getMockEndpoint("mock:d").expectedBodiesReceived(new Object[]{"C"});
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMulticastPipeline() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)((MulticastDefinition)this.from("direct:start").multicast().pipeline(new String[]{"direct:a", "direct:b"})).pipeline(new String[]{"direct:c", "direct:d"})).end().to("mock:result");
                ((RouteDefinition)this.from("direct:a").to("mock:a")).setBody().constant((Object)"A");
                ((RouteDefinition)this.from("direct:b").to("mock:b")).setBody().constant((Object)"B");
                ((RouteDefinition)this.from("direct:c").to("mock:c")).setBody().constant((Object)"C");
                ((RouteDefinition)this.from("direct:d").to("mock:d")).setBody().constant((Object)"D");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"A"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:d").expectedBodiesReceived(new Object[]{"C"});
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMulticastPipelineTo() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((PipelineDefinition)((PipelineDefinition)this.from("direct:start").multicast().pipeline().to(new String[]{"direct:a", "direct:b"})).end().pipeline().to(new String[]{"direct:c", "direct:d"})).end().end().to("mock:result");
                ((RouteDefinition)this.from("direct:a").to("mock:a")).setBody().constant((Object)"A");
                ((RouteDefinition)this.from("direct:b").to("mock:b")).setBody().constant((Object)"B");
                ((RouteDefinition)this.from("direct:c").to("mock:c")).setBody().constant((Object)"C");
                ((RouteDefinition)this.from("direct:d").to("mock:d")).setBody().constant((Object)"D");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"A"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:d").expectedBodiesReceived(new Object[]{"C"});
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

