/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="Short timeouts cause problems with parallel text execution")
public class MulticastParallelTimeoutTest
extends ContextTestSupport {
    @Test
    public void testMulticastParallelTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((MockValueBuilder)mock.message(0).body()).not(MulticastParallelTimeoutTest.body().contains((Object)"A"));
        this.getMockEndpoint("mock:A").expectedMessageCount(0);
        this.getMockEndpoint("mock:B").expectedMessageCount(1);
        this.getMockEndpoint("mock:C").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from("direct:start").multicast(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().timeout(250L).to(new String[]{"direct:a", "direct:b", "direct:c"})).end().to("mock:result");
                ((ExpressionNode)this.from("direct:a").delay(1000L).to("mock:A")).setBody((Expression)this.constant("A"));
                ((RouteDefinition)this.from("direct:b").to("mock:B")).setBody((Expression)this.constant("B"));
                ((RouteDefinition)this.from("direct:c").to("mock:C")).setBody((Expression)this.constant("C"));
            }
        };
    }
}

