/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledIfSystemProperty(named="ci.env.name", matches=".*", disabledReason="Unreliable on virtual machines")
@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x")
public class MulticastParallelTimeoutStreamCachingTest
extends ContextTestSupport {
    private static final String BODY_STRING = "message body";
    private static final byte[] BODY = "message body".getBytes(StandardCharsets.UTF_8);

    @Test
    public void testCreateOutputStreamCacheAfterTimeout() throws Exception {
        this.getMockEndpoint("mock:x").expectedBodiesReceived(new Object[]{BODY_STRING});
        this.template.sendBody("direct:a", (Object)"testMessage");
        this.assertMockEndpointsSatisfied();
        File f = this.testDirectory().toFile();
        Assertions.assertTrue((boolean)f.isDirectory());
        Thread.sleep(500L);
        File[] files = f.listFiles();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)0, (int)files.length);
    }

    @Test
    public void testCreateOutputStreamCacheBeforeTimeoutButWriteToOutputStreamCacheAfterTimeout() throws Exception {
        this.getMockEndpoint("mock:exception").expectedMessageCount(1);
        this.getMockEndpoint("mock:y").expectedMessageCount(0);
        this.template.sendBody("direct:b", (Object)"testMessage");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        final Processor processor1 = new Processor(){

            public void process(Exchange exchange) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Unexpected exception", e);
                }
                Message in = exchange.getIn();
                in.setBody((Object)new FilterInputStream(new ByteArrayInputStream(BODY)){});
            }
        };
        final Processor processor2 = new Processor(){

            public void process(Exchange exchange) throws IOException {
                CachedOutputStream outputStream = new CachedOutputStream(exchange);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Unexpected exception", e);
                }
                outputStream.write(BODY);
                Message in = exchange.getIn();
                in.setBody((Object)outputStream.getInputStream());
            }
        };
        return new RouteBuilder(){

            public void configure() {
                MulticastParallelTimeoutStreamCachingTest.this.context.getStreamCachingStrategy().setSpoolDirectory(MulticastParallelTimeoutStreamCachingTest.this.testDirectory().toFile());
                MulticastParallelTimeoutStreamCachingTest.this.context.getStreamCachingStrategy().setSpoolEnabled(true);
                MulticastParallelTimeoutStreamCachingTest.this.context.getStreamCachingStrategy().setEnabled(true);
                MulticastParallelTimeoutStreamCachingTest.this.context.getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(false);
                MulticastParallelTimeoutStreamCachingTest.this.context.getStreamCachingStrategy().setSpoolThreshold(1L);
                MulticastParallelTimeoutStreamCachingTest.this.context.setStreamCaching(Boolean.valueOf(true));
                this.onException(IOException.class).to("mock:exception");
                this.from("direct:a").multicast().timeout(500L).parallelProcessing().to("direct:x");
                ((RouteDefinition)this.from("direct:x").process(processor1)).to("mock:x");
                this.from("direct:b").multicast().timeout(500L).parallelProcessing().to("direct:y");
                ((RouteDefinition)this.from("direct:y").process(processor2)).to("mock:y");
            }
        };
    }
}

