/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="Does not play well with parallel execution")
public class MulticastParallelTimeoutAwareTest
extends ContextTestSupport {
    private volatile Exchange receivedExchange;
    private volatile int receivedIndex;
    private volatile int receivedTotal;
    private volatile long receivedTimeout;

    @Test
    public void testMulticastParallelTimeoutAware() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((MockValueBuilder)mock.message(0).body()).not(MulticastParallelTimeoutAwareTest.body().contains((Object)"A"));
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)this.receivedExchange);
        Assertions.assertEquals((int)0, (int)this.receivedIndex);
        Assertions.assertEquals((int)3, (int)this.receivedTotal);
        Assertions.assertEquals((long)1000L, (long)this.receivedTimeout);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from("direct:start").multicast((AggregationStrategy)new MyAggregationStrategy()).parallelProcessing().timeout(1000L).to(new String[]{"direct:a", "direct:b", "direct:c"})).end().to("mock:result");
                this.from("direct:a").delay(2000L).setBody((Expression)this.constant("A"));
                this.from("direct:b").setBody((Expression)this.constant("B"));
                this.from("direct:c").delay(500L).setBody((Expression)this.constant("C"));
            }
        };
    }

    private class MyAggregationStrategy
    implements AggregationStrategy {
        private MyAggregationStrategy() {
        }

        public void timeout(Exchange oldExchange, int index, int total, long timeout) {
            MulticastParallelTimeoutAwareTest.this.receivedExchange = oldExchange;
            MulticastParallelTimeoutAwareTest.this.receivedIndex = index;
            MulticastParallelTimeoutAwareTest.this.receivedTotal = total;
            MulticastParallelTimeoutAwareTest.this.receivedTimeout = timeout;
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
            return oldExchange;
        }
    }
}

