/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MulticastParallelSynchronousTest
extends ContextTestSupport {
    private String before;
    private String middle;
    private String middle2;
    private String after;

    @Test
    public void testSynchronous() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"A");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotEquals((Object)this.before, (Object)this.middle);
        Assertions.assertNotEquals((Object)this.before, (Object)this.middle2);
        Assertions.assertNotEquals((Object)this.after, (Object)this.middle);
        Assertions.assertNotEquals((Object)this.after, (Object)this.middle2);
        Assertions.assertEquals((Object)this.before, (Object)this.after);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)((MulticastDefinition)((RouteDefinition)this.from("direct:a").process(e -> {
                    MulticastParallelSynchronousTest.this.before = Thread.currentThread().getName();
                })).multicast().parallelProcessing().synchronous().process(e -> {
                    MulticastParallelSynchronousTest.this.middle = Thread.currentThread().getName();
                })).process(e -> {
                    MulticastParallelSynchronousTest.this.middle2 = Thread.currentThread().getName();
                })).end().process(e -> {
                    MulticastParallelSynchronousTest.this.after = Thread.currentThread().getName();
                }).to("mock:end");
            }
        };
    }
}

