/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class MulticastParallelStressTest
extends ContextTestSupport {
    @Test
    public void testTwoMulticast() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"ABCD", "ABCD"});
        mock.expectsAscending().header("id");
        this.template.sendBodyAndHeader("direct:start", (Object)"", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"", "id", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMoreMulticast() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(20);
        mock.expectsAscending().header("id");
        for (int i = 0; i < 20; ++i) {
            this.template.sendBodyAndHeader("direct:start", (Object)"", "id", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConcurrencyParallelMulticast() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(20);
        mock.expectsNoDuplicates((Expression)MulticastParallelStressTest.header("id"));
        ExecutorService executor = Executors.newFixedThreadPool(10);
        int i = 0;
        while (i < 20) {
            final int index = i++;
            executor.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    MulticastParallelStressTest.this.template.sendBodyAndHeader("direct:start", (Object)"", "id", (Object)index);
                    return null;
                }
            });
        }
        this.assertMockEndpointsSatisfied();
        executor.shutdownNow();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from("direct:start").multicast(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().to(new String[]{"direct:a", "direct:b", "direct:c", "direct:d"})).end().to("mock:result");
                this.from("direct:a").delay(20L).setBody((Expression)this.body().append((Object)"A"));
                this.from("direct:b").setBody((Expression)this.body().append((Object)"B"));
                this.from("direct:c").delay(50L).setBody((Expression)this.body().append((Object)"C"));
                this.from("direct:d").delay(10L).setBody((Expression)this.body().append((Object)"D"));
            }
        };
    }
}

