/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class MulticastParallelStreamingTimeoutTest
extends ContextTestSupport {
    @Test
    public void testMulticastParallelStreamingTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"CB"});
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from("direct:start").multicast(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().streaming().timeout(2000L).to(new String[]{"direct:a", "direct:b", "direct:c"})).end().to("mock:result");
                this.from("direct:a").delay(3000L).setBody((Expression)this.constant("A"));
                this.from("direct:b").delay(500L).setBody((Expression)this.constant("B"));
                this.from("direct:c").setBody((Expression)this.constant("C"));
            }
        };
    }
}

