/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
@Timeout(value=60L)
public class MulticastParallelLastTimeoutTest
extends ContextTestSupport {
    private final Phaser phaser = new Phaser(3);

    @BeforeEach
    void sendEarly() {
        Assumptions.assumeTrue((boolean)this.context.isStarted(), (String)"The test cannot be run because the context is not started");
        this.template.sendBody("direct:start", (Object)"Hello");
    }

    @Test
    public void testMulticastParallelLastTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"AB"});
        this.phaser.awaitAdvanceInterruptibly(0, 5000L, TimeUnit.SECONDS);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from("direct:start").multicast(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().timeout(2000L).to(new String[]{"direct:a", "direct:b", "direct:c"})).end().to("mock:result");
                ((RouteDefinition)this.from("direct:a").process(e -> MulticastParallelLastTimeoutTest.this.phaser.arriveAndAwaitAdvance())).delay(500L).setBody((Expression)this.constant("A"));
                ((RouteDefinition)this.from("direct:b").process(e -> MulticastParallelLastTimeoutTest.this.phaser.arriveAndAwaitAdvance())).setBody((Expression)this.constant("B"));
                ((RouteDefinition)this.from("direct:c").process(e -> MulticastParallelLastTimeoutTest.this.phaser.arriveAndAwaitAdvance())).delay(3000L).setBody((Expression)this.constant("C"));
            }
        };
    }
}

