/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MulticastParallelFailureEndpointTest
extends ContextTestSupport {
    @Test
    public void testMulticastParallel() throws Exception {
        Exchange result = this.runTest("direct:run");
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"direct://a", (Object)result.getProperty("CamelFailureEndpoint"));
    }

    @Test
    public void testMulticastParallelWithTryCatch() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        Exchange result = this.runTest("direct:start");
        Assertions.assertNotNull((Object)result);
        Assertions.assertNull((Object)result.getProperty("CamelFailureEndpoint"));
    }

    public Exchange runTest(String uri) throws Exception {
        MockEndpoint mr = this.getMockEndpoint("mock:run");
        MockEndpoint ma = this.getMockEndpoint("mock:a");
        MockEndpoint mb = this.getMockEndpoint("mock:b");
        mr.expectedMessageCount(0);
        ma.expectedMessageCount(0);
        mb.expectedMessageCount(1);
        DefaultExchange request = new DefaultExchange((CamelContext)this.context, ExchangePattern.InOut);
        request.getIn().setBody((Object)"Hello World");
        Exchange result = this.template.send(uri, (Exchange)request);
        this.assertMockEndpointsSatisfied();
        return result;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)this.from("direct:start").doTry().to("direct:run")).doCatch(IllegalArgumentException.class).end().to("mock:result");
                ((MulticastDefinition)this.from("direct:run").multicast().parallelProcessing().to(new String[]{"direct:a", "direct:b"})).end().to("mock:run");
                ((RouteDefinition)this.from("direct:a").throwException((Exception)new IllegalArgumentException("Oops..."))).to("mock:a");
                ((RouteDefinition)this.from("direct:b").setBody((Expression)this.constant("Bye World"))).to("mock:b");
            }
        };
    }
}

