/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Animal;
import org.apache.camel.processor.AnimalDeepClonePrepare;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MulticastOnPrepareTest
extends ContextTestSupport {
    @Test
    public void testMulticastOnPrepare() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:a").message(0).body(String.class)).isEqualTo((Object)"1 Tony the Tiger");
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:b").message(0).body(String.class)).isEqualTo((Object)"1 Tiger");
        this.template.sendBody("direct:start", (Object)new Animal(1, "Tiger"));
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from("direct:start").multicast().onPrepare((Processor)new AnimalDeepClonePrepare()).to("direct:a")).to("direct:b");
                ((RouteDefinition)this.from("direct:a").process((Processor)new ProcessorA())).to("mock:a");
                ((RouteDefinition)this.from("direct:b").process((Processor)new ProcessorB())).to("mock:b");
            }
        };
    }

    public static class ProcessorB
    implements Processor {
        public void process(Exchange exchange) {
            Animal body = (Animal)exchange.getIn().getBody(Animal.class);
            Assertions.assertEquals((int)1, (int)body.getId());
            Assertions.assertEquals((Object)"Tiger", (Object)body.getName());
        }
    }

    public static class ProcessorA
    implements Processor {
        public void process(Exchange exchange) {
            Animal body = (Animal)exchange.getIn().getBody(Animal.class);
            Assertions.assertEquals((int)1, (int)body.getId());
            Assertions.assertEquals((Object)"Tiger", (Object)body.getName());
            body.setName("Tony the Tiger");
        }
    }
}

