/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class MulticastKeepOriginalMessageUnchangedTest
extends ContextTestSupport {
    @Test
    public void testUnchanged() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:a").message(0).header("foo")).isNull();
        ((MockValueBuilder)this.getMockEndpoint("mock:a").message(0).header("bar")).isEqualTo((Object)"no");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).header("foo")).isNull();
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).header("bar")).isEqualTo((Object)"no");
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Foo was here Hello World"});
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("foo", (Object)"yes");
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).header("bar")).isNull();
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:a").setHeader("bar", (Expression)this.constant("no"))).to("mock:a")).multicast(AggregationStrategies.useOriginal()).to("direct:foo")).end().to("mock:result");
                ((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:foo").setHeader("foo", (Expression)this.constant("yes"))).removeHeader("bar")).transform().simple("Foo was here ${body}")).to("mock:foo");
            }
        };
    }
}

