/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.junit.jupiter.api.Test;

public class MulticastDslTest
extends ContextTestSupport {
    @Test
    public void testMulticastDsl() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("onPrepare", (Object)true);
        mock.expectedBodiesReceived(new Object[]{5});
        this.template.sendBody("direct:start", (Object)1);
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)((MulticastDefinition)((MulticastDefinition)((MulticastDefinition)this.from("direct:start").multicast().onPrepare().message(m -> m.setHeader("onPrepare", (Object)true))).aggregationStrategy().body(Integer.class, (o, n) -> o != null ? o + n : n)).to("direct:increase-by-1")).to("direct:increase-by-2")).end().to("mock:result");
                this.from("direct:increase-by-1").bean((Object)new Increase(1));
                this.from("direct:increase-by-2").bean((Object)new Increase(2));
            }
        };
    }

    public static class Increase {
        private final int amount;

        public Increase(int amount) {
            this.amount = amount;
        }

        public int add(int num) {
            return num + this.amount;
        }
    }
}

