/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MulticastCorrelationIdTest
extends ContextTestSupport {
    MulticastCorrelationIdTest() {
    }

    @Test
    void testCorrelationIdIsNotOverwrittenByMulticast() {
        String originalCorrelationId = "SOME_ID";
        Exchange exchange = this.template.request("direct:start", e -> e.setProperty("CamelCorrelationId", (Object)originalCorrelationId));
        Assertions.assertEquals((Object)originalCorrelationId, (Object)exchange.getProperty("CamelCorrelationId"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").multicast().to(new String[]{"direct:a", "direct:b"});
                this.from("direct:a").log("Route a");
                this.from("direct:b").log("Route b");
            }
        };
    }
}

