/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Test;

public class MulticastCompletedPropertyTest
extends ContextTestSupport {
    @Test
    public void testMulticastCompleted() throws Exception {
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        ((MockValueBuilder)a.message(0).exchangeProperty("CamelMulticastComplete")).isEqualTo((Object)false);
        MockEndpoint b = this.getMockEndpoint("mock:b");
        b.expectedMessageCount(1);
        ((MockValueBuilder)b.message(0).exchangeProperty("CamelMulticastComplete")).isEqualTo((Object)false);
        MockEndpoint c = this.getMockEndpoint("mock:c");
        c.expectedMessageCount(1);
        ((MockValueBuilder)c.message(0).exchangeProperty("CamelMulticastComplete")).isEqualTo((Object)true);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").multicast().to(new String[]{"mock:a", "mock:b", "mock:c"});
            }
        };
    }
}

