/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Test;

public class MultiCastParallelAndStreamCachingWithEncryptionTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MultiCastParallelAndStreamCachingWithEncryptionTest.this.context.setStreamCaching(Boolean.valueOf(true));
                MultiCastParallelAndStreamCachingWithEncryptionTest.this.context.getStreamCachingStrategy().setEnabled(true);
                MultiCastParallelAndStreamCachingWithEncryptionTest.this.context.getStreamCachingStrategy().setSpoolDirectory(MultiCastParallelAndStreamCachingWithEncryptionTest.this.testDirectory().toFile());
                MultiCastParallelAndStreamCachingWithEncryptionTest.this.context.getStreamCachingStrategy().setSpoolThreshold(5000L);
                MultiCastParallelAndStreamCachingWithEncryptionTest.this.context.getStreamCachingStrategy().setSpoolCipher("AES/CTR/NoPadding");
                ((MulticastDefinition)this.from("direct:start").multicast().parallelProcessing().stopOnException().to(new String[]{"direct:a", "direct:b"})).end().to("mock:result");
                ((RouteDefinition)this.from("direct:a").process((Processor)new SimpleProcessor())).to("mock:resulta");
                ((RouteDefinition)this.from("direct:b").process((Processor)new SimpleProcessor())).to("mock:resultb");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileInputStreamCache() throws Exception {
        InputStream resultA = this.getPayload();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOHelper.copy((InputStream)resultA, (OutputStream)baos);
        IOHelper.close((Closeable)resultA);
        byte[] resultBytes = baos.toByteArray();
        MockEndpoint mock = this.getMockEndpoint("mock:resulta");
        mock.expectedBodiesReceived(Collections.singletonList(resultBytes));
        mock = this.getMockEndpoint("mock:resultb");
        mock.expectedBodiesReceived(Collections.singletonList(resultBytes));
        try (InputStream in = this.getPayload();){
            this.template.sendBody("direct:start", (Object)in);
            this.assertMockEndpointsSatisfied();
        }
    }

    private InputStream getPayload() {
        return MultiCastParallelAndStreamCachingWithEncryptionTest.class.getClassLoader().getResourceAsStream("org/apache/camel/processor/payload10KB.txt");
    }

    private static class SimpleProcessor
    implements Processor {
        private SimpleProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            Object body = exchange.getIn().getBody();
            if (!(body instanceof InputStream)) {
                throw new RuntimeException("Type " + body.getClass().getName() + " not supported");
            }
            InputStream inputStream = (InputStream)body;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            inputStream.transferTo(output);
            exchange.getMessage().setBody((Object)output.toByteArray());
        }
    }
}

