/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.xml.StringSource;
import org.junit.jupiter.api.Test;

public class MultiCastParallelAndStreamCachingTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MultiCastParallelAndStreamCachingTest.this.context.setStreamCaching(Boolean.valueOf(true));
                MultiCastParallelAndStreamCachingTest.this.context.getStreamCachingStrategy().setEnabled(true);
                MultiCastParallelAndStreamCachingTest.this.context.getStreamCachingStrategy().setSpoolDirectory(MultiCastParallelAndStreamCachingTest.this.testDirectory().toFile());
                MultiCastParallelAndStreamCachingTest.this.context.getStreamCachingStrategy().setSpoolThreshold(5L);
                ((MulticastDefinition)this.from("direct:start").multicast().parallelProcessing().stopOnException().to(new String[]{"direct:a", "direct:b"})).end().to("mock:result");
                ((RouteDefinition)this.from("direct:a").process((Processor)new SimpleProcessor(false))).to("mock:resulta");
                ((RouteDefinition)this.from("direct:b").process((Processor)new SimpleProcessor(true))).to("mock:resultb");
            }
        };
    }

    @Test
    public void testByteArrayInputStreamCache() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:resulta");
        mock.expectedBodiesReceived(new Object[]{"<start></start>"});
        mock = this.getMockEndpoint("mock:resultb");
        mock.expectedBodiesReceived(new Object[]{"<start></start>"});
        this.template.sendBody("direct:start", (Object)new ByteArrayInputStream("<start></start>".getBytes(StandardCharsets.UTF_8)));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFileInputStreamCache() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:resulta");
        mock.expectedBodiesReceived(new Object[]{"James,Guillaume,Hiram,Rob,Roman"});
        mock = this.getMockEndpoint("mock:resultb");
        mock.expectedBodiesReceived(new Object[]{"James,Guillaume,Hiram,Rob,Roman"});
        InputStream in = MultiCastParallelAndStreamCachingTest.class.getClassLoader().getResourceAsStream("org/apache/camel/processor/simple.txt");
        this.template.sendBody("direct:start", (Object)in);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInputStreamCache() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:resulta");
        mock.expectedBodiesReceived(new Object[]{"A"});
        MockEndpoint mockb = this.getMockEndpoint("mock:resultb");
        mockb.expectedBodiesReceived(new Object[]{"A"});
        InputStream in = MultiCastParallelAndStreamCachingTest.class.getClassLoader().getResourceAsStream("org/apache/camel/processor/oneCharacter.txt");
        this.template.sendBody("direct:start", (Object)in);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testReaderCache() throws Exception {
        String abcScharpS = "ABC\u00df";
        MockEndpoint mock = this.getMockEndpoint("mock:resulta");
        mock.expectedBodiesReceived(new Object[]{abcScharpS});
        mock = this.getMockEndpoint("mock:resultb");
        mock.expectedBodiesReceived(new Object[]{abcScharpS});
        InputStreamReader isr = new InputStreamReader((InputStream)new ByteArrayInputStream(abcScharpS.getBytes(StandardCharsets.ISO_8859_1)), StandardCharsets.ISO_8859_1);
        this.template.sendBody("direct:start", (Object)isr);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testStreamSourceCacheWithInputStream() throws Exception {
        String input = "<A>a</A>";
        MockEndpoint mock = this.getMockEndpoint("mock:resulta");
        mock.expectedBodiesReceived(new Object[]{input});
        mock = this.getMockEndpoint("mock:resultb");
        mock.expectedBodiesReceived(new Object[]{input});
        StreamSource ss = new StreamSource(new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8)));
        this.template.sendBody("direct:start", (Object)ss);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testStreamSourceCacheWithReader() throws Exception {
        String input = "ABC\u00df";
        MockEndpoint mock = this.getMockEndpoint("mock:resulta");
        mock.expectedBodiesReceived(new Object[]{input});
        mock = this.getMockEndpoint("mock:resultb");
        mock.expectedBodiesReceived(new Object[]{input});
        InputStreamReader isr = new InputStreamReader((InputStream)new ByteArrayInputStream(input.getBytes(StandardCharsets.ISO_8859_1)), StandardCharsets.ISO_8859_1);
        StreamSource ss = new StreamSource(isr);
        this.template.sendBody("direct:start", (Object)ss);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSourceCache() throws Exception {
        String input = "<A>a</A>";
        MockEndpoint mock = this.getMockEndpoint("mock:resulta");
        mock.expectedBodiesReceived(new Object[]{input});
        mock = this.getMockEndpoint("mock:resultb");
        mock.expectedBodiesReceived(new Object[]{input});
        StringSource ss = new StringSource(input);
        SAXSource saxSource = new SAXSource(SAXSource.sourceToInputSource((Source)ss));
        this.template.sendBody("direct:start", (Object)saxSource);
        this.assertMockEndpointsSatisfied();
    }

    private static class SimpleProcessor
    implements Processor {
        private final boolean withSleepTime;

        SimpleProcessor(boolean withSleepTime) {
            this.withSleepTime = withSleepTime;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void process(Exchange exchange) throws Exception {
            Object body;
            if (this.withSleepTime) {
                Thread.sleep(50L);
            }
            if ((body = exchange.getIn().getBody()) instanceof InputStream) {
                InputStream inputStream = (InputStream)body;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                IOHelper.copy((InputStream)inputStream, (OutputStream)output);
                exchange.getMessage().setBody((Object)output.toByteArray());
                return;
            } else if (body instanceof Reader) {
                Reader reader = (Reader)body;
                String string = IOHelper.toString((Reader)reader);
                exchange.getMessage().setBody((Object)string);
                return;
            } else {
                if (!(body instanceof StreamSource)) throw new RuntimeException("Type " + body.getClass().getName() + " not supported");
                StreamSource ss = (StreamSource)body;
                if (ss.getInputStream() != null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    IOHelper.copy((InputStream)ss.getInputStream(), (OutputStream)output);
                    exchange.getMessage().setBody((Object)output.toByteArray());
                    return;
                } else {
                    if (ss.getReader() == null) throw new RuntimeException("StreamSource without InputStream and without Reader not supported");
                    Reader reader = ss.getReader();
                    String string = IOHelper.toString((Reader)reader);
                    exchange.getMessage().setBody((Object)string);
                }
            }
        }
    }
}

