/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Variable;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class MethodFilterVariableTest
extends ContextTestSupport {
    @Test
    public void testSendMatchingMessage() throws Exception {
        String body = "<person name='James' city='London'/>";
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{body});
        this.template.sendBodyAndHeader("direct:start", ExchangePattern.InOut, (Object)body, "city", (Object)"London");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendNotMatchingMessage() throws Exception {
        String body = "<person name='Hiram' city='Tampa'/>";
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", ExchangePattern.InOut, (Object)body, "city", (Object)"Tampa");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((FilterDefinition)((RouteDefinition)this.from("direct:start").setVariable("location", (Expression)this.header("city"))).filter().method("myBean", "matches")).to("mock:result");
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    public static class MyBean {
        public boolean matches(@Variable(value="location") String location) {
            return "London".equals(location);
        }
    }
}

