/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class MethodFilterTest
extends ContextTestSupport {
    @Test
    public void testSendMatchingMessage() throws Exception {
        String body = "<person name='James' city='London'/>";
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{body});
        this.template.sendBodyAndHeader("direct:start", ExchangePattern.InOut, (Object)body, "foo", (Object)"London");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendNotMatchingMessage() throws Exception {
        String body = "<person name='Hiram' city='Tampa'/>";
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", ExchangePattern.InOut, (Object)body, "foo", (Object)"Tampa");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((FilterDefinition)this.from("direct:start").filter().method("myBean", "matches")).to("mock:result");
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    public static class MyBean {
        public boolean matches(@Header(value="foo") String location) {
            return "London".equals(location);
        }
    }
}

