/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.StepDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MessageHistoryCopyMessageTest
extends ContextTestSupport {
    @Test
    public void testCopyMessage() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        Exchange out = this.template.request("direct:start", e -> e.getMessage().setBody((Object)"Hello World"));
        this.assertMockEndpointsSatisfied();
        List history = (List)out.getProperty("CamelMessageHistory", List.class);
        Assertions.assertNotNull((Object)history);
        Assertions.assertEquals((int)3, (int)history.size());
        Assertions.assertEquals((Object)"step", (Object)((MessageHistory)history.get(0)).getNode().getShortName());
        Assertions.assertEquals((Object)"a", (Object)((MessageHistory)history.get(0)).getNode().getId());
        Assertions.assertEquals((Object)"Hello World", (Object)((MessageHistory)history.get(0)).getMessage().getBody());
        Assertions.assertEquals((Object)"step", (Object)((MessageHistory)history.get(1)).getNode().getShortName());
        Assertions.assertEquals((Object)"b", (Object)((MessageHistory)history.get(1)).getNode().getId());
        Assertions.assertEquals((Object)"Bye World", (Object)((MessageHistory)history.get(1)).getMessage().getBody());
        Assertions.assertEquals((Object)"step", (Object)((MessageHistory)history.get(2)).getNode().getShortName());
        Assertions.assertEquals((Object)"bar", (Object)((MessageHistory)history.get(2)).getNode().getId());
        Assertions.assertEquals((Object)"Hi World", (Object)((MessageHistory)history.get(2)).getMessage().getBody());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MessageHistoryCopyMessageTest.this.context.setMessageHistory(Boolean.valueOf(true));
                MessageHistoryCopyMessageTest.this.context.getMessageHistoryFactory().setNodePattern("step");
                MessageHistoryCopyMessageTest.this.context.getMessageHistoryFactory().setCopyMessage(true);
                ((StepDefinition)((StepDefinition)((ProcessorDefinition)((StepDefinition)((ProcessorDefinition)this.from("direct:start").step("a").transform().constant((Object)"Bye World")).to("mock:a")).end().step("b").transform().constant((Object)"Hi World")).to("direct:bar")).to("mock:b")).end();
                ((StepDefinition)((StepDefinition)this.from("direct:bar").step("bar").to("log:bar")).to("mock:bar")).end();
            }
        };
    }
}

