/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class MDCWireTapTest
extends ContextTestSupport {
    @Test
    public void testMDC() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MDCWireTapTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                ((ToDynamicDefinition)((ToDynamicDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:a").routeId("route-a").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-a", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                        MDC.put((String)"custom.id", (String)"1");
                    }
                })).to("log:before-wiretap")).wireTap("direct:b").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-a", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                        Assertions.assertEquals((Object)"1", (Object)MDC.get((String)"custom.id"));
                    }
                })).to("log:a-done")).to("mock:a");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").routeId("route-b").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-b", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                        Assertions.assertEquals((Object)"1", (Object)MDC.get((String)"custom.id"));
                    }
                })).to("log:b-done")).to("mock:b");
            }
        };
    }
}

