/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.StepDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class MDCTest
extends ContextTestSupport {
    @Test
    public void testMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMDCTwoMessages() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.sendBody("direct:a", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MDCTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                ((StepDefinition)((StepDefinition)((StepDefinition)this.from("direct:a").routeId("route-a").step("step-a").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-a", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                        Assertions.assertEquals((Object)exchange.getIn().getMessageId(), (Object)MDC.get((String)"camel.messageId"));
                        Assertions.assertEquals((Object)"step-a", (Object)MDC.get((String)"camel.stepId"));
                        MDC.put((String)"custom.id", (String)"1");
                    }
                })).to("log:foo")).to("direct:b")).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-a", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                        Assertions.assertEquals((Object)exchange.getIn().getMessageId(), (Object)MDC.get((String)"camel.messageId"));
                        Assertions.assertEquals((Object)"step-a", (Object)MDC.get((String)"camel.stepId"));
                    }
                });
                ((StepDefinition)((StepDefinition)this.from("direct:b").routeId("route-b").step("step-b").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-b", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                        Assertions.assertEquals((Object)exchange.getIn().getMessageId(), (Object)MDC.get((String)"camel.messageId"));
                        Assertions.assertEquals((Object)"step-b", (Object)MDC.get((String)"camel.stepId"));
                        Assertions.assertEquals((Object)"1", (Object)MDC.get((String)"custom.id"));
                    }
                })).to("log:bar")).to("mock:result");
            }
        };
    }
}

