/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class MDCSplitParallelProcessingTest
extends ContextTestSupport {
    @Test
    public void testMdcPreservedAfterAsyncEndpoint() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"A,B");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MDCSplitParallelProcessingTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                MDCSplitParallelProcessingTest.this.context.setUseBreadcrumb(Boolean.valueOf(true));
                MDCSplitParallelProcessingTest.this.context.setMDCLoggingKeysPattern("custom*,my*");
                MdcCheckerProcessor checker = new MdcCheckerProcessor();
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:a").routeId("route-async").process(e -> {
                    MDC.put((String)"custom.hello", (String)"World");
                    MDC.put((String)"foo", (String)"Bar");
                    MDC.put((String)"myKey", (String)"Baz");
                })).process((Processor)checker)).to("log:foo")).split((Expression)this.body().tokenize(",")).parallelProcessing().process((Processor)checker)).end().to("mock:end");
            }
        };
    }

    private static class MdcCheckerProcessor
    implements Processor {
        private String exchangeId;
        private String messageId;
        private String breadcrumbId;
        private String contextId;
        private Long threadId;
        private String foo;

        private MdcCheckerProcessor() {
        }

        public void process(Exchange exchange) {
            Assertions.assertEquals((Object)"World", (Object)MDC.get((String)"custom.hello"));
            Assertions.assertEquals((Object)"Baz", (Object)MDC.get((String)"myKey"));
            if (this.foo != null) {
                Assertions.assertNotEquals((Object)this.foo, (Object)MDC.get((String)"foo"));
            } else {
                this.foo = MDC.get((String)"foo");
            }
            if (this.threadId != null) {
                long currId = Thread.currentThread().getId();
                Assertions.assertNotEquals((Object)this.threadId, (Object)currId);
            } else {
                this.threadId = Thread.currentThread().getId();
            }
            String routeId = "route-async";
            if (routeId != null) {
                Assertions.assertEquals((Object)routeId, (Object)MDC.get((String)"camel.routeId"));
            }
            if (this.exchangeId != null) {
                Assertions.assertNotEquals((Object)this.exchangeId, (Object)MDC.get((String)"camel.exchangeId"));
            } else {
                this.exchangeId = MDC.get((String)"camel.exchangeId");
                Assertions.assertTrue((this.exchangeId != null && !this.exchangeId.isEmpty() ? 1 : 0) != 0);
            }
            if (this.messageId != null) {
                Assertions.assertNotEquals((Object)this.messageId, (Object)MDC.get((String)"camel.messageId"));
            } else {
                this.messageId = MDC.get((String)"camel.messageId");
                Assertions.assertTrue((this.messageId != null && !this.messageId.isEmpty() ? 1 : 0) != 0);
            }
            if (this.breadcrumbId != null) {
                Assertions.assertEquals((Object)this.breadcrumbId, (Object)MDC.get((String)"camel.breadcrumbId"));
            } else {
                this.breadcrumbId = MDC.get((String)"camel.breadcrumbId");
                Assertions.assertTrue((this.breadcrumbId != null && !this.breadcrumbId.isEmpty() ? 1 : 0) != 0);
            }
            if (this.contextId != null) {
                Assertions.assertEquals((Object)this.contextId, (Object)MDC.get((String)"camel.contextId"));
            } else {
                this.contextId = MDC.get((String)"camel.contextId");
                Assertions.assertTrue((this.contextId != null && !this.contextId.isEmpty() ? 1 : 0) != 0);
            }
        }
    }
}

