/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

@Disabled
public class MDCResetMidRouteProducerTemplateTest
extends ContextTestSupport {
    @Test
    public void testMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Good Afternoon World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMDCTwoMessages() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Good Afternoon World", "Good Afternoon World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.sendBody("direct:a", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MDCResetMidRouteProducerTemplateTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:a").routeId("route-a").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-a", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                    }
                })).to("log:foo")).to("direct:b")).process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        body = (String)MDCResetMidRouteProducerTemplateTest.this.template.requestBody("direct:b", (Object)body, String.class);
                        exchange.getMessage().setBody((Object)body);
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-a", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                    }
                })).to("log:result")).to("mock:result");
                ((RouteDefinition)this.from("direct:b").routeId("route-b").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-b", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                        exchange.getMessage().setBody((Object)"Good Afternoon World");
                    }
                })).to("log:bar");
            }
        };
    }
}

