/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCOnCompletionOnCompletionTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MDCOnCompletionOnCompletionTest.class);

    @Test
    public void testMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MDCOnCompletionOnCompletionTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                ((OnCompletionDefinition)((ProcessorDefinition)this.from("timer:foo?period=5000").routeId("route-a").setBody().constant((Object)"Hello World")).onCompletion().process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getExchangeExtension().addOnCompletion((Synchronization)new MyOnCompletion());
                    }
                })).end().to("log:foo").to("direct:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").routeId("route-b").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"route-b", (Object)MDC.get((String)"camel.routeId"));
                        Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
                        Assertions.assertEquals((Object)exchange.getIn().getMessageId(), (Object)MDC.get((String)"camel.messageId"));
                        MDC.put((String)"custom.id", (String)"1");
                        LOG.info("From processor in route-b");
                    }
                })).to("log:bar")).to("mock:result");
            }
        };
    }

    private static class MyOnCompletion
    extends SynchronizationAdapter {
        private MyOnCompletion() {
        }

        public void onDone(Exchange exchange) {
            Assertions.assertEquals((Object)"route-a", (Object)MDC.get((String)"camel.routeId"));
            Assertions.assertEquals((Object)exchange.getExchangeId(), (Object)MDC.get((String)"camel.exchangeId"));
            Assertions.assertEquals((Object)exchange.getIn().getMessageId(), (Object)MDC.get((String)"camel.messageId"));
            Assertions.assertEquals((Object)"1", (Object)MDC.get((String)"custom.id"));
            LOG.info("From onCompletion after route-a");
        }
    }
}

