/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class MDCErrorHandlerTest
extends ContextTestSupport {
    @Test
    public void testMDC() {
        this.template.sendBody("direct:start", (Object)"Hello World");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MDCErrorHandlerTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                MDCErrorHandlerTest.this.context.setUseBreadcrumb(Boolean.valueOf(true));
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("direct:dead").onExceptionOccurred(new Processor(){

                    public void process(Exchange exchange) {
                        Map m = MDC.getCopyOfContextMap();
                        Assertions.assertEquals((int)5, (int)m.size());
                        Assertions.assertEquals((Object)exchange.getMessage().getHeader("breadcrumbId"), m.get("camel.breadcrumbId"));
                        Assertions.assertEquals((Object)"start", m.get("camel.routeId"));
                    }
                }));
                ((RouteDefinition)this.from("direct:start").routeId("start").to("log:before")).throwException((Exception)new IllegalArgumentException("Forced"));
                ((RouteDefinition)this.from("direct:dead").routeId("dead").process(new Processor(){

                    public void process(Exchange exchange) {
                        Map m = MDC.getCopyOfContextMap();
                        Assertions.assertEquals((int)5, (int)m.size());
                        Assertions.assertEquals((Object)exchange.getMessage().getHeader("breadcrumbId"), m.get("camel.breadcrumbId"));
                        Assertions.assertEquals((Object)"dead", m.get("camel.routeId"));
                    }
                })).to("log:dead");
            }
        };
    }
}

