/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class MDCCustomKeysTest
extends ContextTestSupport {
    private final MdcCheckerProcessor checker1 = new MdcCheckerProcessor("N/A");
    private final MdcCheckerProcessor checker2 = new MdcCheckerProcessor("World");

    @Test
    public void testMdcPreserved() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.checker1.reset();
        this.checker2.reset();
        this.template.sendBody("direct:a", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMdcPreservedTwo() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedBodiesReceived(new Object[]{"A", "B"});
        this.checker1.reset();
        this.checker2.reset();
        this.template.sendBody("direct:a", (Object)"A");
        this.checker1.reset();
        this.checker2.reset();
        this.template.sendBody("direct:a", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MDCCustomKeysTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                MDCCustomKeysTest.this.context.setUseBreadcrumb(Boolean.valueOf(true));
                MDCCustomKeysTest.this.context.setMDCLoggingKeysPattern("custom*,my*");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:a").process(e -> {
                    String hello = MDC.get((String)"custom.hello");
                    Assertions.assertNull((Object)hello);
                    MDC.put((String)"custom.hello", (String)"N/A");
                    MDC.put((String)"foo", (String)"Bar");
                    MDC.put((String)"myKey", (String)"Baz");
                })).process((Processor)MDCCustomKeysTest.this.checker1)).to("log:foo")).process(e -> MDC.put((String)"custom.hello", (String)"World"))).process((Processor)MDCCustomKeysTest.this.checker2)).to("mock:end");
            }
        };
    }

    private static class MdcCheckerProcessor
    implements Processor {
        private String exchangeId;
        private String messageId;
        private String breadcrumbId;
        private String contextId;
        private Long threadId;
        private String foo;
        private final String expected;

        public MdcCheckerProcessor(String expected) {
            this.expected = expected;
        }

        public void reset() {
            this.exchangeId = null;
            this.messageId = null;
            this.breadcrumbId = null;
            this.contextId = null;
            this.threadId = null;
            this.foo = null;
        }

        public void process(Exchange exchange) {
            Assertions.assertEquals((Object)this.expected, (Object)MDC.get((String)"custom.hello"));
            Assertions.assertEquals((Object)"Baz", (Object)MDC.get((String)"myKey"));
            if (this.foo != null) {
                Assertions.assertEquals((Object)this.foo, (Object)MDC.get((String)"foo"));
            } else {
                this.foo = MDC.get((String)"foo");
            }
            if (this.threadId != null) {
                long currId = Thread.currentThread().getId();
                Assertions.assertEquals((Object)this.threadId, (Object)currId);
            } else {
                this.threadId = Thread.currentThread().getId();
            }
            if (this.exchangeId != null) {
                Assertions.assertNotEquals((Object)this.exchangeId, (Object)MDC.get((String)"camel.exchangeId"));
            } else {
                this.exchangeId = MDC.get((String)"camel.exchangeId");
                Assertions.assertTrue((this.exchangeId != null && !this.exchangeId.isEmpty() ? 1 : 0) != 0);
            }
            if (this.messageId != null) {
                Assertions.assertNotEquals((Object)this.messageId, (Object)MDC.get((String)"camel.messageId"));
            } else {
                this.messageId = MDC.get((String)"camel.messageId");
                Assertions.assertTrue((this.messageId != null && !this.messageId.isEmpty() ? 1 : 0) != 0);
            }
            if (this.breadcrumbId != null) {
                Assertions.assertEquals((Object)this.breadcrumbId, (Object)MDC.get((String)"camel.breadcrumbId"));
            } else {
                this.breadcrumbId = MDC.get((String)"camel.breadcrumbId");
                Assertions.assertTrue((this.breadcrumbId != null && !this.breadcrumbId.isEmpty() ? 1 : 0) != 0);
            }
            if (this.contextId != null) {
                Assertions.assertEquals((Object)this.contextId, (Object)MDC.get((String)"camel.contextId"));
            } else {
                this.contextId = MDC.get((String)"camel.contextId");
                Assertions.assertTrue((this.contextId != null && !this.contextId.isEmpty() ? 1 : 0) != 0);
            }
        }
    }
}

