/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.AsyncProcessorSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCClearingTest
extends ContextTestSupport {
    public static final String CAMEL_BREADCRUMB_ID = "camel.breadcrumbId";
    public static final String BREADCRUMB_ID = "breadcrumbId";
    public static final String MY_BREADCRUMB = "my breadcrumb";
    private static final Logger LOG = LoggerFactory.getLogger(MDCClearingTest.class);
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);

    @Test
    public void shouldPropagateAndClearMdcInSyncRoute() {
        MDC.remove((String)CAMEL_BREADCRUMB_ID);
        this.template.requestBodyAndHeader("direct:test-sync", (Object)"TEST", BREADCRUMB_ID, (Object)MY_BREADCRUMB);
        Assertions.assertNull((Object)MDC.get((String)CAMEL_BREADCRUMB_ID));
    }

    @Test
    public void shouldPropagateAndClearMdcInAsyncRoute() {
        MDC.remove((String)CAMEL_BREADCRUMB_ID);
        this.template.requestBodyAndHeader("direct:test-async", (Object)"TEST", BREADCRUMB_ID, (Object)MY_BREADCRUMB);
        Assertions.assertNull((Object)MDC.get((String)CAMEL_BREADCRUMB_ID));
    }

    @Test
    public void shouldPropagateAndClearMdcInMixedRoute() {
        MDC.remove((String)CAMEL_BREADCRUMB_ID);
        this.template.requestBodyAndHeader("direct:test-mixed", (Object)"TEST", BREADCRUMB_ID, (Object)MY_BREADCRUMB);
        Assertions.assertNull((Object)MDC.get((String)CAMEL_BREADCRUMB_ID));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.setUseMDCLogging(Boolean.valueOf(true));
        camelContext.setUseBreadcrumb(Boolean.valueOf(true));
        return camelContext;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:test-sync").process((Processor)new MySyncProcessor("STEP 1"));
                this.from("direct:test-async").process((Processor)new MyAsyncProcessor("STEP 2"));
                ((RouteDefinition)this.from("direct:test-mixed").process((Processor)new MyAsyncProcessor("STEP 3"))).process((Processor)new MySyncProcessor("STEP 4"));
            }
        };
    }

    private class MyAsyncProcessor
    extends AsyncProcessorSupport {
        private final String msg;

        public MyAsyncProcessor(String msg) {
            this.msg = msg;
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            LOG.info(this.msg);
            Assertions.assertEquals((Object)MDCClearingTest.MY_BREADCRUMB, (Object)MDC.get((String)MDCClearingTest.CAMEL_BREADCRUMB_ID));
            MDCClearingTest.this.executorService.execute(() -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                callback.done(false);
            });
            return false;
        }
    }

    private static class MySyncProcessor
    implements Processor {
        private final String msg;

        public MySyncProcessor(String msg) {
            this.msg = msg;
        }

        public void process(Exchange exchange) {
            LOG.info(this.msg);
            Assertions.assertEquals((Object)MDCClearingTest.MY_BREADCRUMB, (Object)MDC.get((String)MDCClearingTest.CAMEL_BREADCRUMB_ID));
        }
    }
}

