/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;

public class LoopWithAggregatorTest
extends ContextTestSupport {
    @Test
    public void testLoopCopy() throws Exception {
        this.getMockEndpoint("mock:loop").expectedBodiesReceived(new Object[]{"AB", "AB", "AB"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AB"});
        this.template.requestBody("direct:start", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)this.from("direct:start").loop(3).copy().enrich("direct:getTimeStamp", (AggregationStrategy)new ExampleAggregationStrategy())).to(ExchangePattern.InOnly, "mock:loop")).end().to("mock:result");
                this.from("direct:getTimeStamp").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getIn().setBody((Object)"B");
                    }
                });
            }
        };
    }

    public static class ExampleAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange original, Exchange resource) {
            String originalBody = (String)original.getIn().getBody(String.class);
            if (original.getMessage().getBody() != null) {
                originalBody = (String)original.getMessage().getBody(String.class);
            }
            String resourceResponse = (String)resource.getIn().getBody(String.class);
            String mergeResult = originalBody + resourceResponse;
            if (original.getPattern().isOutCapable()) {
                original.getMessage().setBody((Object)mergeResult);
            } else {
                original.getIn().setBody((Object)mergeResult);
            }
            return original;
        }
    }
}

