/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.processor.LoopTestProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LoopTest
extends ContextTestSupport {
    MockEndpoint resultEndpoint;

    @Test
    public void testCounterLoop() throws Exception {
        this.performLoopTest("direct:a", 8);
    }

    @Test
    public void testExpressionLoop() throws Exception {
        this.performLoopTest("direct:b", 6);
    }

    @Test
    public void testExpressionClauseLoop() throws Exception {
        this.performLoopTest("direct:c", 4);
    }

    @Test
    public void testLoopAsBlock() throws Exception {
        MockEndpoint lastEndpoint = this.resolveMandatoryEndpoint("mock:last", MockEndpoint.class);
        lastEndpoint.expectedMessageCount(1);
        this.performLoopTest("direct:d", 2);
        lastEndpoint.assertIsSatisfied();
    }

    @Test
    public void testLoopWithInvalidExpression() throws Exception {
        try {
            this.performLoopTest("direct:b", 4, "invalid");
            Assertions.fail((String)"Exception expected for invalid expression");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
    }

    @Test
    public void testLoopProperties() throws Exception {
        this.performLoopTest("direct:e", 10);
    }

    private void performLoopTest(String endpointUri, int expectedIterations, String header) throws InterruptedException {
        this.resultEndpoint.expectedMessageCount(expectedIterations);
        this.template.sendBodyAndHeader(endpointUri, (Object)"<hello times='4'>world!</hello>", "loop", (Object)header);
        this.resultEndpoint.assertIsSatisfied();
    }

    private void performLoopTest(String endpointUri, int expectedIterations) throws InterruptedException {
        this.performLoopTest(endpointUri, expectedIterations, "6");
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        this.resultEndpoint.reset();
    }

    protected RouteBuilder createRouteBuilder() {
        final LoopTestProcessor loopTest = new LoopTestProcessor(10);
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").loop(8).to("mock:result");
                this.from("direct:b").loop((Expression)this.header("loop")).to("mock:result");
                ((LoopDefinition)this.from("direct:c").loop().xpath("/hello/@times")).to("mock:result");
                ((ExpressionNode)this.from("direct:d").loop(2).to("mock:result")).end().to("mock:last");
                ((ExpressionNode)this.from("direct:e").loop(10).process(loopTest)).to("mock:result");
            }
        };
    }
}

