/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;

public class LoopOnPrepareTest
extends ContextTestSupport {
    @Test
    public void testLoopOnPrepare() throws Exception {
        this.getMockEndpoint("mock:loop").expectedBodiesReceived(new Object[]{"AB", "AB", "AB"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AB"});
        this.template.sendBody("direct:start", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)this.from("direct:start").loop(3).onPrepare((Processor)new MyPrepare()).transform((Expression)this.body().append((Object)"B"))).to("mock:loop")).end().to("mock:result");
            }
        };
    }

    private class MyPrepare
    implements Processor {
        private String original;

        private MyPrepare() {
        }

        public void process(Exchange exchange) throws Exception {
            if (this.original == null) {
                this.original = (String)exchange.getMessage().getBody(String.class);
            } else {
                exchange.getMessage().setBody((Object)this.original);
            }
        }
    }
}

