/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

class LoopNoBreakOnShutdownTest
extends ContextTestSupport {
    private static final int LOOP_COUNT = 100;

    LoopNoBreakOnShutdownTest() {
    }

    @Test
    void testLoopNoBreakOnShutdown() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(100);
        CompletableFuture future = this.template.asyncSendBody("seda:foo", (Object)"foo");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(future::isDone);
        this.context.stop();
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").startupOrder(1).loop(100).delay(50L).to("seda:bar");
                this.from("seda:bar").startupOrder(2).shutdownRoute(ShutdownRoute.Defer).to("mock:result");
            }
        };
    }
}

