/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.LoopProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LoopDoWhileTaskCountTest
extends ContextTestSupport {
    @Test
    public void testLoopDoWhileSimple() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AAAAAA"});
        this.getMockEndpoint("mock:loop").expectedBodiesReceived(new Object[]{"A", "AA", "AAA", "AAAA", "AAAAA"});
        this.template.sendBody("direct:simple", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("direct:simple").loopDoWhile((Predicate)this.simple("${body.length} <= 5")).id("myLoop")).process(exchange -> {
                    LoopProcessor lp = (LoopProcessor)exchange.getContext().getProcessor("myLoop", LoopProcessor.class);
                    int size = lp.getPendingExchangesSize();
                    Assertions.assertEquals((int)0, (int)size);
                })).to("mock:loop")).transform((Expression)this.body().append((Object)"A"))).end().to("mock:result");
            }
        };
    }
}

