/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Test;

public class LoopDoWhileDelayTest
extends ContextTestSupport {
    @Test
    public void testLoopDoWhileSimple() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AAAAAA"});
        this.getMockEndpoint("mock:loop").expectedBodiesReceived(new Object[]{"A", "AA", "AAA", "AAAA", "AAAAA"});
        this.template.sendBody("direct:simple", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLoopDoWhileFunctional() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AAAAAA"});
        this.getMockEndpoint("mock:loop").expectedBodiesReceived(new Object[]{"A", "AA", "AAA", "AAAA", "AAAAA"});
        this.template.sendBody("direct:functional", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)this.from("direct:simple").loopDoWhile((Predicate)this.simple("${body.length} <= 5")).to("mock:loop")).transform((Expression)this.body().append((Object)"A"))).delay(10L).end().end().to("mock:result");
                ((ProcessorDefinition)((ExpressionNode)((LoopDefinition)this.from("direct:functional").loopDoWhile().body(String.class, b -> b.length() <= 5)).to("mock:loop")).transform().body(String.class, b -> {
                    b = (String)b + "A";
                    return b;
                })).delay(10L).end().end().to("mock:result");
            }
        };
    }
}

